using System;
using Server;
using Server.Items;
using Server.Misc;

namespace Server.Mobiles
{
	//[CorpseName( "a black order grand mage corpse" )] 
	public class DragonsFlameGrandMage : DragonsFlameMage
	{	
		[Constructable]
		public DragonsFlameGrandMage() : base()
		{
			Name = "black order grand mage";
			Title = "of the dragon's flame sect";
			SetHits( 602, 815 );
// 			
// 			if (Utility.RandomDouble() < 0.1)
// 			   PackItem( Loot.RandomArcanistScroll() );
		}

		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public DragonsFlameGrandMage( Serial serial ) : base( serial )
		{
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.AosFilthyRich );
		}
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );
			
// 			if ( Utility.RandomDouble() < 0.8 )
// 			{
				Item item = new Klic();
				item.ItemID = 0x1012;
				item.Name = "dragon flame key";
				item.Hue = 33;
            c.DropItem( item );
//          }
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}
